Attribute VB_Name = "Sifyb"
Option Explicit

'what is new
'2.6.9 : gs_iniFile commented out (JN)


Private Const SEP As String = ""
#If LIVE = 1 Then
Private Const sRV As String = "UKDC-CAPPRD1.apollo.local"
Private Const INST As String = ""
Private Const DBN As String = "SIFYB2"
Private Const DRPSRV As String = "10.249.1.130"
Private Const APPSDIR As String = "C:\Arm_apps\APOLLO_Sifyb"
Private Const DLLDIR As String = "C:\Arm_apps\Dll"
Private Const A_ENV As String = "LIVE"
#Else
Private Const sRV As String = "UXBDB020"

Private Const INST As String = "APOLLOT"
Private Const DBN As String = "SIFYB2"
Private Const DRPSRV As String = "UXBDB020" 'same server as no drp test server
Private Const A_ENV As String = "DEVELOPMENT ENVIRONMENT"


Private Const APPSDIR As String = "C:\Arm_apps\APOLLOD_Sifyb"
Private Const DLLDIR As String = "C:\Arm_apps\Dll"


#End If

Private Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long

Private Type Common_info
    Session_Key                 As String
    session_line_order          As Integer
    WTS                         As Boolean
    DBName                      As String
    ServerIP                    As String
    DRPServerIP                 As String
    CurrentServerIP             As String
    ServerInstance              As String
    ApplicationName             As String
    ApplicationVersion          As String
    LoginName                   As String
    U_Code                      As String
    U_PWD                       As String
    Cursor                      As Long
    ODBC_ConnectString          As String
    Session_language            As String
    Session_language_Code       As String
    FTP_ServerName              As String
    FTP_HostIP                  As String
    FTP_ServerIP                As String
    FTP_Login                   As String
    FTP_PWD                     As String
    FTP_HostName                As String
    Upgrade_FTP_FullPath        As String
    Upgrade_Download_FullPath   As String
    Application_Dir             As String
    Dll_Dir                     As String
    Environment                 As String
    FullName                    As String
    
    AppCache_Dir                As String           ' JN 2.7.2014
End Type

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1 ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    CompFncFailed = vbObjectError + 6          ' when component function fail
    loginfailed = vbObjectError + 7          ' when Login fail
    UserCopyAbort = vbObjectError + 8               ' when user click abort copy
    InvalidValue = vbObjectError + 9               ' invalid version, invalid
End Enum

Global prg As Common_info
Global sifyb_info As String
Global gl_Database As Long
Global gl_Environment As Long
Global gs_message As String
Global gb_Connected As Boolean


'Used only in development
Global gs_PreferedLanguage As String
Global gs_DefaultLogin As String

Global gl_CodeComputer As Long
'Global gs_IniFile As String
Global gs_IniVersion As String
Global gs_Sifyb0Version As String
Global gs_ServerIP As String
Global gs_DBName As String
Global gs_ServerIP_DRP As String


Global gs_Language() As String

'Used for Large Font Test
Global Const MM_TEXT = 1
#If LIVE Then
Global aDb As Object, adb_err As Object
#Else
Global aDb As New ArmDb, adb_err As New ArmDb
#End If

Type TEXTMETRIC
    tmHeight As Integer
    tmAscent As Integer
    tmDescent As Integer
    tmInternalLeading As Integer
    tmExternalLeading As Integer
    tmAveCharWidth As Integer
    tmMaxCharWidth As Integer
    tmWeight As Integer
    tmItalic As String * 1
    tmUnderlined As String * 1
    tmStruckOut As String * 1
    tmFirstChar As String * 1
    tmLastChar As String * 1
    tmDefaultChar As String * 1
    tmBreakChar As String * 1
    tmPitchAndFamily As String * 1
    tmCharSet As String * 1
    tmOverHang As Integer
    tmDigitizedAspectX As Integer
    tmDigitizedAspectY As Integer
End Type



Declare Function GetTextMetrics Lib "gdi32" Alias "GetTextMetricsA" (ByVal hdc As Long, lpMetrics As TEXTMETRIC) As Long
Declare Function GetDesktopWindow Lib "user32" () As Long
Declare Function GetWindowDC Lib "user32" (ByVal hwnd As Long) As Long
Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hdc As Long) As Long
Declare Function SetMapMode Lib "gdi32" (ByVal hdc As Long, ByVal nMapMode As Long) As Long

Private Declare Function GetWindowsDirectory Lib "Kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function GetSystemDirectory Lib "Kernel32" Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long


Public Sub TestResolution()
Dim hdc, hwnd, PrevMapMode As Long
Dim tm As TEXTMETRIC

    hwnd = GetDesktopWindow()
    hdc = GetWindowDC(hwnd)
    If hdc Then
        PrevMapMode = SetMapMode(hdc, MM_TEXT)
        GetTextMetrics hdc, tm
        PrevMapMode = SetMapMode(hdc, PrevMapMode)
        ReleaseDC hwnd, hdc
        If tm.tmHeight > 16 Then
            MsgBox "Your Windows System uses Large Font." & Chr(13) & Chr(13) & "It must be possible that Sifyb cannot run correctly" & Chr(13) & Chr(13) & "Contact your system administrator to correct this problem", vbCritical, "Product Database"
        End If
    End If
End Sub

Sub LoadFromIniFile()
Dim ls_language As String
Dim i As Integer
Dim ls_Section As String
Dim ls_Key As String
Dim lo_Registry As New Registry
Dim lo_IniFile As New IniFiles
    
    'Initialize the arm_sys.ini file position
    lo_IniFile.FileName = App.Path & "\arm_sys.ini"
    lo_IniFile.OpenFile
    
    TestResolution

    lo_Registry.RootKey = HKEY_CURRENT_USER
    lo_Registry.OpenSubKey REG_APP_NAME & REG_APP_OPTION, OK
    lo_Registry.GetValue REG_PREF_LANGUAGE, gs_PreferedLanguage
    lo_Registry.GetValue REG_DEFAULT_LOGIN, gs_DefaultLogin
    lo_Registry.CloseCurrentKey

    lo_IniFile.CloseFile
    
End Sub

Private Function check_Sifyb_version() As Integer
On Error GoTo check_Sifyb_version_er
Dim ll_try As Integer, lb_Result As Boolean
Dim lJobResult As Long
check_Sifyb_version = 0 ' Function failed
prg.Cursor = aDb.OpenSQL("select cfg_value from a_config where cfg_key='SIFYB' and cfg_value = '" & App.Major & "." & App.Minor & "." & App.Revision & "'")
    If prg.Cursor = 0 Then
    MsgBox "An Unexpected error occured while verifying program version "
    Exit Function
    End If
    If aDb.RowCount(prg.Cursor) = 0 Then
        Screen.MousePointer = 0
        check_Sifyb_version = 2 'upgrade needed
    Else
    Screen.MousePointer = 0
    check_Sifyb_version = 1 ' No upgrade, we can continue
    End If
    Call aDb.Close(prg.Cursor)
    
Exit Function
check_Sifyb_version_er:
Screen.MousePointer = 0
MsgBox "Unexpected error " & Err.Number & " " & Err.Description
End Function

Private Function check_Upgrade_Version(ByVal CFG_key As String, ByVal checked_file As String, ByVal local_FullPath As String, ByVal local_Path As String, ByVal need_registration As Boolean) As Boolean
On Error GoTo check_Upgrade_Version_er
Dim ll_try As Integer, lb_Result As Boolean
Dim lJobResult As Long, res As Long
Dim current_version As String, local_version As String
check_Upgrade_Version = False
prg.Cursor = aDb.OpenSQL("select cfg_value from a_config where cfg_key='" & CFG_key & "'")
    If prg.Cursor = 0 Then
    MsgBox "An Unexpected SQL error occured while reading A_Icons version "
    Exit Function
    End If
    If aDb.RowCount(prg.Cursor) = 0 Or aDb.RowCount(prg.Cursor) > 1 Then
    Call aDb.Close(prg.Cursor)
    MsgBox "An Unexpected error occured while verifying " & checked_file & " version "
    Exit Function
    End If
    If aDb.RowCount(prg.Cursor) = 1 Then
    current_version = aDb.GetFields(prg.Cursor, "cfg_value")
    End If
        Call aDb.Close(prg.Cursor)
        local_version = GetFileCurrentVersion(local_FullPath, False)
        If Val(Replace(current_version, ".", "")) <> Val(Replace(local_version, ".", "")) Then
        
        If need_registration Then
        res = Shell("regsvr32.exe /s /u " & local_FullPath, vbHide)
        If fileexist(local_FullPath) Then
        DeleteFile (local_FullPath)
        End If

        End If
        Screen.MousePointer = 11
            For ll_try = 1 To 3
            If aDb.BlobToFileSQL("select F_Data_file from A_Files where F_File_key ='" & CFG_key & "'", local_FullPath, True, False) Then
            lb_Result = True
            Exit For
            End If
            Next ll_try
            If lb_Result Then
            check_Upgrade_Version = True
            If need_registration Then
            res = Shell("regsvr32.exe /s " & local_FullPath, vbHide)
            End If
            Else
            MsgBox CFG_key & " is missing and could not be downloaded automatically. Please contact IT. Application cannot start"
            End If
        Else
        check_Upgrade_Version = True
        End If
Screen.MousePointer = 0
Exit Function
check_Upgrade_Version_er:
Screen.MousePointer = 0
MsgBox "Unexpected error " & Err.Number & " " & Err.Description & " in function check_Upgrade_Version"
End Function

Private Function Read_Config_Version(ByVal CFG_key As String) As String
On Error GoTo Read_Config_Version_er
Read_Config_Version = "0"
Screen.MousePointer = 11
prg.Cursor = aDb.OpenSQL("select cfg_value from a_config where cfg_key='" & CFG_key & "'")
    If prg.Cursor = 0 Then
    MsgBox "An Unexpected SQL error occured while reading " & CFG_key & "  version in A_config"
    Exit Function
    End If
    If aDb.RowCount(prg.Cursor) = 0 Or aDb.RowCount(prg.Cursor) > 1 Then
    Call aDb.Close(prg.Cursor)
    MsgBox "No or moe than one record for key " & CFG_key & "  in A_config"
    Exit Function
    End If
    If aDb.RowCount(prg.Cursor) = 1 Then
    Read_Config_Version = aDb.GetFields(prg.Cursor, "cfg_value")
    End If
    Call aDb.Close(prg.Cursor)
Screen.MousePointer = 0
Exit Function
Read_Config_Version_er:
Screen.MousePointer = 0
MsgBox "Unexpected error " & Err.Number & " " & Err.Description & " in function Read_Config_Version"
End Function

Function fileexist(ByVal f As String) As Boolean
On Error GoTo fileexist_er:
fileexist = False
   Dim fso As Object
    Set fso = CreateObject("Scripting.FileSystemObject")
   If fso.FileExists(f) Then
   fileexist = True
   End If
   Set fso = Nothing
   
   Exit Function
fileexist_er:
   Select Case Err.Number:
   Case 53:
   Case Else: MsgBox "Error in searching for Capoff"
   End Select
End Function

Function DeleteFile(ByVal f As String) As Boolean
On Error GoTo deletefile_er:
   Dim fso As Object
   DeleteFile = False
Set fso = CreateObject("Scripting.FileSystemObject")
   fso.DeleteFile f, True
   DeleteFile = True
   Set fso = Nothing
   Exit Function
deletefile_er:
   Set fso = Nothing
   Select Case Err.Number:
   Case 53:
   Case Else: MsgBox "Process was unable to delete file " & f
   End Select
End Function

Private Function GetFileCurrentVersion(ByVal as_filePath As String, ByVal type3 As Boolean) As String
On Error GoTo GetFileCurrentVersion_er
GetFileCurrentVersion = ""
Dim wrk As String
Dim Pos1, Pos2, pos3, pos4 As Integer
    Dim lo_fs As Object
    Set lo_fs = CreateObject("Scripting.FileSystemObject")
    If lo_fs.FileExists(as_filePath) Then
    wrk = lo_fs.GetFileVersion(as_filePath)
    If type3 Then
    Pos1 = InStr(1, wrk, ".")
    Pos2 = InStr(Pos1 + 1, wrk, ".")
    pos3 = InStr(Pos2 + 1, wrk, ".")
    
    GetFileCurrentVersion = Left(wrk, Pos2) + Mid(wrk, pos3 + 1, 10)
    Else
    GetFileCurrentVersion = wrk
    End If
    Else
    GetFileCurrentVersion = ""
    End If
    Set lo_fs = Nothing
Exit Function
GetFileCurrentVersion_er:
GetFileCurrentVersion = ""
    Set lo_fs = Nothing
    MsgBox "Unexpected error: " & Err.Number & "  " & Err.Description
End Function


Private Function InVB() As Boolean
On Error GoTo InVB:
Debug.Print (1 / 0)
InVB = False
Exit Function

InVB:
    InVB = True

End Function

Sub Main()
Dim ls_language As String
Dim lb_CanRun As Boolean
Dim li_Status As Integer
Dim ind As Integer
Dim c As Long
Dim need_upgrade As Integer
Dim armsyscom_config_version As String
Dim armsyscom_local_version As String
Dim lb_LogConnectionIssue As Boolean

Dim s As String

On Error GoTo suite

lb_LogConnectionIssue = False
s = "prg_Init"
prg_init

s = s & vbCrLf & "Check app location"
#If LIVE Then
    If Not InVB Then
        If UCase(App.EXEName) <> "SIFYB" Then
            MsgBox "Application Name invalid"
            End
        End If
        
        If UCase(App.Path) <> UCase(prg.Application_Dir) And Not prg.WTS Then
            MsgBox "Application cannot start if not running from " & prg.Application_Dir & " directory"
            End
        End If
    End If
#End If


s = s & vbCrLf & "Check Terminal server"
'this control of not authorizing more than one instance is not applied if running under TSE.
    If Left(Environ("SESSIONNAME"), 3) <> "RDP" Then
        Dim ls_Caption As String
        Dim ll_Hwnd As Long
        
        ls_Caption = App.Title
        App.Title = "*" & ls_Caption
        
        ll_Hwnd = FindWindow("ThunderRT6Main", ls_Caption)
        
'        If App.PrevInstance = True Then
        If ll_Hwnd <> 0 Then
            Screen.MousePointer = 0
            MsgBox "Programm already in use. End of this session", 16
            End
        End If
        App.Title = ls_Caption
    Else
        prg.WTS = True
        prg.AppCache_Dir = Environ("USERPROFILE") & "\Cache"
    End If

s = s & vbCrLf & "Check Armsyscom version"
Dim ls_fso As Object
Set ls_fso = CreateObject("Scripting.FileSystemObject")
    If ls_fso.FileExists(GetwindowsDir & "\A_syscom.dll") Then
    MsgBox "A_syscom DLL present in Windows Directory!"
    Set ls_fso = Nothing
    Exit_Application
End If
    
    If ls_fso.FileExists(GetSysDir & "\A_syscom.dll") Then
    MsgBox "A_syscom DLL present in Windows System Directory!"
    Set ls_fso = Nothing
    Exit_Application
    End If
    

If Not ls_fso.FileExists(prg.Dll_Dir & "\A_syscom.dll") Then
MsgBox "A_syscom DLL not available in " & prg.Dll_Dir & " directory. Application cannot start"
Set ls_fso = Nothing
Exit_Application
End If

Set ls_fso = Nothing

s = s & vbCrLf & "Create environment"

If Not CreateDir(prg.Application_Dir & "\Download") Then
    MsgBox "Cannot create " & prg.Application_Dir & "\Download directory"
    End
End If
If Not CreateDir(prg.AppCache_Dir) Then
    MsgBox "Cannot create " & prg.AppCache_Dir & " directory"
    End
End If
If Not CreateDir(prg.AppCache_Dir & "\DC_Temp") Then
    MsgBox "Cannot create " & prg.AppCache_Dir & "\DC_Temp directory"
    End
End If


s = s & vbCrLf & "Clean upgrade"
If Not prg.WTS Then clean_upgrade

s = s & vbCrLf & "Create armsyscom"
#If LIVE Then
Set aDb = CreateObject("ARMSYSCOM.ArmDb")
#End If


'''''''''''''''    CONNECT EN PREMIER AVEC ARMLOG

s = s & vbCrLf & "Test sql cnx"
' We connect first to find out which server is responding (alternate server to be selected in case of DRP)
If Not aDb.Connect(prg.ServerIP & prg.ServerInstance, prg.DBName, "Test_connection", "try25x", "Test_connection") Then
    MsgBox "Main server is not responding, trying alternate server..." & prg.ServerIP & prg.ServerInstance & " " & GetArrayValue(aDb.SQLErrorMessages, 0)
    
        If Not aDb.Connect(prg.DRPServerIP & prg.ServerInstance, prg.DBName, "Test_connection", "try25x", "Test_connection") Then
            MsgBox "Alternate server is not responding..."
            Set aDb = Nothing
            End
        Else
            prg.CurrentServerIP = prg.DRPServerIP  ' we change the global server IP variable to redirect to DRP server
            lb_LogConnectionIssue = True
        End If
Else
    prg.CurrentServerIP = prg.ServerIP
End If
s = s & vbCrLf & "Check upgrade of dll"



Dim ls_Request As String
ls_Request = "SELECT CFG_Value FROM A_Config WHERE CFG_Key = 'SQLON'"
Dim lc_SQLON As Long, ls_SQLON As String
lc_SQLON = aDb.OpenSQL(ls_Request)
ls_SQLON = aDb.GetFields(lc_SQLON, "CFG_Value")
aDb.Close (lc_SQLON)

Dim ls_pc_name As String
    Dim loNetObject As Object
    Set loNetObject = CreateObject("WScript.Network")
    ls_pc_name = Left(loNetObject.ComputerName, 50)
    Set loNetObject = Nothing
    
If ls_SQLON <> "X" Then
    ' JN 1.3.2012 - additional check to suppress sqlon chceck for some PCs
    
    Dim lb_sqlon As Boolean
    Dim ll_Cursor As Long
    ll_Cursor = aDb.OpenSQL("SELECT 1 FROM A_Config WHERE CFG_Key = 'SQLON-SKIP' AND CFG_Value like '%" & ls_pc_name & "%'")
    lb_sqlon = aDb.RowCount(ll_Cursor) = 1
    Call aDb.Close(ll_Cursor)

    If Not lb_sqlon Then
    
        Call ASC_SendMessage(aDb, "E", 8728, "The Database is unavailable due to IT Maintenance. Please try later.", "", vbCritical, "Sifyb " & prg.Environment & "  Version : " & App.Major & "." & App.Minor & "." & App.Revision)
        End
    End If
End If


If Not prg.WTS Then
    log_version
    If Not check_Upgrade_Version("A_ICONS", "A_Icones", prg.Dll_Dir & "\A_icons.dll", "C:\Arm_Apps\dll", False) Then Exit_Application
    If Not check_Upgrade_Version("Armlog", "Armlog", prg.Dll_Dir & "\Armlog.dll", "C:\Arm_Apps\dll", False) Then Exit_Application
    log_version
End If



s = s & vbCrLf & "Check sifyb upgrade"
need_upgrade = check_Sifyb_version
' record if need upgrade
Select Case need_upgrade
    Case 0: 'an error occured in check_version function
        Exit_Application
    Case 1: ' no upgrade needed
    ' check Armsyscom to ensure correct version goes with exe
        If Not prg.WTS Then
            armsyscom_config_version = Read_Config_Version("ARMSYSCOM")
            armsyscom_local_version = GetFileCurrentVersion(prg.Dll_Dir & "\a_syscom.dll", False)
            If Val(Replace(armsyscom_local_version, ".", "")) < Val(Replace(armsyscom_config_version, ".", "")) Then
               MsgBox "Armsyscom version not up to date. Current is " & armsyscom_local_version & ", Should be : " & armsyscom_config_version
               Exit_Application
            End If
        End If
    Case 2:
        If Not prg.WTS Then
            sifyb_info = "Upgrade needed"
            Call aDb.ExecuteSQL("INSERT INTO Sifyb_info(Session_key, Session_line_order,record_type, session_date, session_info) VALUES('" & prg.Session_Key & "'," & prg.session_line_order & ",'" & prg.LoginName & "','2', getdate() ,'" & sifyb_info & ")")
            prg.session_line_order = prg.session_line_order + 1
            App_Upd.show (vbModal)
            Exit Sub
        Else
            MsgBox "Application is not up to date on the WTS server, please contact IT support "
        End If
End Select

s = s & vbCrLf & "Retrieve language list"
prg.Cursor = aDb.OpenSQL("select language_code,language_desc from language where language_validity='Y' order by language_order")
    If prg.Cursor = 0 Then
       MsgBox "Unexpected error occured while loading languages selection "
        Exit_Application
    End If
    ReDim gs_Language(1, aDb.RowCount(prg.Cursor)) As String
s = s & vbCrLf & "Init array"
For ind = 0 To aDb.RowCount(prg.Cursor)
    gs_Language(0, ind) = aDb.GetFields(prg.Cursor, "Language_code")
    gs_Language(1, ind) = aDb.GetFields(prg.Cursor, "Language_desc")
    aDb.Next (prg.Cursor)
Next ind
aDb.Close (prg.Cursor)


MouseOff
lb_CanRun = OK
CacheInit prg.AppCache_Dir

s = s & vbCrLf & "Load ini file"

    LoadFromIniFile
    
    If lb_LogConnectionIssue Then
      Call LogMessage("Primary connect failed. " & ls_pc_name & "-" & gs_DefaultLogin & "-" & prg.ServerIP & prg.ServerInstance, "E")
    End If
    
    s = s & vbCrLf & "launch login form"
    frm_Login.show

Screen.MousePointer = 0
Exit Sub

suite:

    If IsObject(aDb) And Not (aDb Is Nothing) Then
        If aDb.IsConnected Then aDb.Disconnect
    End If
Set aDb = Nothing
MsgBox "srz: " & s
MsgBox "unexpected error " & Err.Number & " " & Err.Description
End
End Sub

Private Sub clean_upgrade()
On Error GoTo clean_upgrade_er
   Dim fso As Object
    Set fso = CreateObject("Scripting.FileSystemObject")
    If fso.FileExists(prg.Application_Dir & "\sifybinst.exe") Then
    fso.DeleteFile (prg.Application_Dir & "\Sifybinst.exe")
    End If
    If fso.FileExists(prg.Application_Dir & "\sifybupd.exe") Then
    fso.DeleteFile (prg.Application_Dir & "\sifybupd.exe")
    End If
Set fso = Nothing
Exit Sub
clean_upgrade_er:
Select Case Err
Case 53: Exit Sub
Case Else
End Select
Set fso = Nothing
End Sub

Public Function NextID(as_Table As String) As Long
Dim ls_req As String
Dim ll_Statement As Long
Dim li_Status As Integer
Dim ll_lngrows As Long

On Error GoTo Err_NextID

NextID = 0

ls_req = "EXEC A_Next_ID  '" & QuoteParam(as_Table) & "'"

If SQLSubmit(gl_Environment, gl_Database, ll_Statement, ls_req) Then
    li_Status = SQLRowCount(ll_Statement, ll_lngrows)
    If ll_lngrows = 0 Then
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
        SendMessage 2100, "ID creation failure, can you contact IT support please.", gut_LangLogin.Code
    Else
        ' Find the code
        li_Status = SQLFetch(ll_Statement)
        If li_Status = SQL_SUCCESS Or li_Status = SQL_SUCCESS_WITH_INFO Then
            NextID = ODBCData(ll_Statement, 1)
        End If
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
    End If
Else
        li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
        SendMessage 2100, "ID creation failure, can you contact IT support please.", gut_LangLogin.Code
End If

Exit Function

Err_NextID:
li_Status = SQLFreeStatement(ll_Statement, SQL_DROP)
StdError
End Function



Public Function get_armsyscom_connection() As Boolean
On Error GoTo get_armsyscom_connection_er
get_armsyscom_connection = False

If Not aDb.Connect(prg.CurrentServerIP & prg.ServerInstance, prg.DBName, prg.LoginName, prg.U_PWD, prg.ApplicationName & prg.ApplicationVersion) Then
MsgBox "Unable to connect to server"
Exit Function
End If

#If LIVE Then
Set adb_err = CreateObject("ARMSYSCOM.ArmDb")
#End If
If Not adb_err.Connect(prg.CurrentServerIP & prg.ServerInstance, prg.DBName, prg.LoginName, prg.U_PWD, prg.ApplicationName & prg.ApplicationVersion) Then
If aDb.IsConnected Then aDb.Disconnect
MsgBox "Unable to connect to server"
Exit Function
End If

get_armsyscom_connection = True
Exit Function
get_armsyscom_connection_er:
MsgBox "Unexpected error " & Err.Number & " " & Err.Description
End Function

Public Function session_end()
aDb.CloseAllCursors
adb_err.CloseAllCursors
aDb.Disconnect
adb_err.Disconnect
Set aDb = Nothing
Set adb_err = Nothing
ODBCDataClose gl_Environment, gl_Database
End Function


Public Function get_login_info() As Boolean

On Error GoTo get_login_info_err
    Dim login_routine_type As Integer
    Dim use_virtual_login As Boolean
    
    use_virtual_login = False
    get_login_info = False
    prg.Cursor = aDb.OpenSQL("select cfg_value from a_config where cfg_key = 'LOGIN_TRANSITION'")
    
    If prg.Cursor = 0 Then
        MsgBox "Unexpected error occured while retrieving login routine type information"
        Exit Function
    End If
    
    If aDb.RowCount(prg.Cursor) = 1 Then
        aDb.First (prg.Cursor)
        login_routine_type = aDb.GetFields(prg.Cursor, "cfg_value")
        If login_routine_type = 0 Then use_virtual_login = True
    Else
        login_routine_type = 1
    End If
    aDb.Close (prg.Cursor)
    prg.FullName = prg.LoginName
    If login_routine_type <> 0 Then
        prg.Cursor = aDb.OpenSQL("select login_name from Temporary_virtual_login_list where login_name = '" & prg.LoginName & "'")
        If prg.Cursor = 0 Then
            MsgBox "Unexpected error occured while retrieving login routine type information"
            Exit Function
        End If
        If aDb.RowCount(prg.Cursor) = 1 Then
            use_virtual_login = True
        End If
        aDb.Close (prg.Cursor)
        If Not use_virtual_login Then
            prg.U_Code = 0
            prg.U_PWD = frm_Login.txt_Pwd
            
            prg.Cursor = aDb.OpenSQL("select u_code, SQL_PWD, P_first_Name + ' ' + P_Name 'FullName'" & vbCrLf & _
                                    "From gen_systems_users gsu " & vbCrLf & _
                                    "inner join gen_people gp on gp.p_code = gsu.p_code" & vbCrLf & _
                                    "where u_login_name ='" & prg.LoginName & "'")
            If prg.Cursor = 0 Then
                MsgBox "Unexpected error occured while retrieving user name information"
                Exit Function
            End If
            If aDb.RowCount(prg.Cursor) = 1 Then
                aDb.First (prg.Cursor)
                prg.U_Code = aDb.GetFields(prg.Cursor, "u_code")
                prg.FullName = aDb.GetFields(prg.Cursor, "FullName")
            End If
            aDb.Close (prg.Cursor)
            Call aDb.ExecuteSQL("INSERT INTO Temporary_Sifyb_login_info(login_name, entered_pwd, login_date, login_routine_type, used_pwd,use_virtual_login) VALUES('" & prg.LoginName & "','" & frm_Login.txt_Pwd & "', getdate() ," & login_routine_type & ",'" & prg.U_PWD & "'," & Int(use_virtual_login) & ")")
            get_login_info = True
        End If
    End If
    If use_virtual_login Then
        prg.Cursor = aDb.OpenSQL("select u_code, SQL_PWD, P_first_Name + ' ' + P_Name 'FullName'" & vbCrLf & _
                                "From gen_systems_users gsu " & vbCrLf & _
                                "inner join gen_people gp on gp.p_code = gsu.p_code" & vbCrLf & _
                                "where u_login_name ='" & prg.LoginName & "' and U_pwd ='" & prg.U_PWD & "'")
        If prg.Cursor = 0 Then
            MsgBox "Unexpected error occured while retrieving user name information"
            Exit Function
        End If
        If aDb.RowCount(prg.Cursor) = 1 Then
            aDb.First (prg.Cursor)
            prg.U_Code = aDb.GetFields(prg.Cursor, "u_code")
            prg.U_PWD = aDb.GetFields(prg.Cursor, "sql_pwd")
            prg.FullName = aDb.GetFields(prg.Cursor, "FullName")
            get_login_info = True
            ' record login info
            Call aDb.ExecuteSQL("INSERT INTO Temporary_Sifyb_login_info(login_name, entered_pwd, login_date, login_routine_type, used_pwd,use_virtual_login) VALUES('" & prg.LoginName & "','" & frm_Login.txt_Pwd & "', getdate() ," & login_routine_type & ",'" & prg.U_PWD & "'," & Int(use_virtual_login) & ")")
        End If
    aDb.Close (prg.Cursor)
    End If
    Exit Function
get_login_info_err:
    MsgBox "Unexpected error " & Err.Number & " " & Err.Description
End Function

Public Function ODBCConnection() As Boolean
    On Error GoTo suite
    ODBCConnection = False
     prg.ODBC_ConnectString = "DRIVER={SQL Server};SERVER=" & prg.CurrentServerIP & prg.ServerInstance _
     & ";UID=" & prg.LoginName & ";PWD=" & prg.U_PWD & ";Database=" & prg.DBName _
     & ";APP=" & prg.ApplicationName & " ODBC " & prg.ApplicationVersion
    If ODBCInit(gl_Environment, gl_Database) Then
        ODBCConnection = ODBCDataOpen(gl_Database, prg.ODBC_ConnectString)
    End If
    
    Exit Function
    
suite:
    StdError
End Function

Public Function Update_PassWord(as_Pwd As String) As Boolean
Const C_REQ = "update gen_systems_users set U_PWD = '$pwd$', Z_last_upd = getdate(), Z_last_upd_user ='$Login$' where u_login_name ='$Login$'"
Dim ls_req As String

On Error GoTo Err_UpdPWD

Update_PassWord = False
    
ls_req = C_REQ
ls_req = Replace(ls_req, "$pwd$", as_Pwd)
ls_req = Replace(ls_req, "$Login$", prg.LoginName)

If Not aDb.ExecuteSQL(ls_req) Then
    Exit Function
End If

If aDb.SQLRowsAffected <= 0 Then
    Exit Function
End If

Update_PassWord = True
Exit Function

Err_UpdPWD:
    MsgBox "Unexpected error " & Err.Number & " " & Err.Description
End Function



Private Function prg_init()


prg.Session_Key = Format(Date, "yyyymmdd") & Format(Time, "hhmmss")
prg.session_line_order = 1

prg.WTS = False
prg.DBName = DBN
prg.ServerIP = sRV
prg.ServerInstance = INST
If prg.ServerInstance <> "" And right(prg.ServerIP, 1) <> "\" Then prg.ServerIP = prg.ServerIP & "\"
prg.DRPServerIP = DRPSRV
If prg.ServerInstance <> "" And right(prg.DRPServerIP, 1) <> "\" Then prg.DRPServerIP = prg.DRPServerIP & "\"

prg.ApplicationName = "Sifyb"
prg.ApplicationVersion = "V " & App.Major & "." & App.Minor & "." & App.Revision
prg.Upgrade_FTP_FullPath = "pwpcubes\sifybupdzip.exe"
prg.Upgrade_Download_FullPath = prg.Application_Dir & "\sifybupdzip.exe"
prg.Application_Dir = APPSDIR
prg.Dll_Dir = DLLDIR
prg.Environment = A_ENV
prg.AppCache_Dir = prg.Application_Dir & "\Cache"
End Function

Private Function Exit_Application()
aDb.Disconnect
Set aDb = Nothing
End
End Function

Private Function log_version()
sifyb_info = sifyb_info & "Armlog Version: " & GetFileCurrentVersion(prg.Dll_Dir & "\armlog.dll", False)
sifyb_info = sifyb_info & ", Armsyscom Version: " & GetFileCurrentVersion(prg.Dll_Dir & "\a_syscom.dll", False)
sifyb_info = sifyb_info & ", Sifyb Version: " & GetFileCurrentVersion(prg.Application_Dir & "\sifyb.exe", True)
sifyb_info = sifyb_info & ", A_icons Version: " & GetFileCurrentVersion(prg.Dll_Dir & "\A_icons.dll", True)
If Not aDb.ExecuteSQL("INSERT INTO Temporary_Sifyb_info(Session_key, Session_line_order,login_name,record_type, session_date, session_info) VALUES('" & prg.Session_Key & "'," & prg.session_line_order & ",'" & prg.LoginName & "','1', getdate() ,'" & sifyb_info & "')") Then MsgBox "error"
prg.session_line_order = prg.session_line_order + 1
End Function

Private Sub LogMessage(ByVal as_LogMsg As String, Optional ByVal as_LogType As String = "I")

Const InsertReq As String = "EXEC A_log_ins $UCODE$, $LOGTYPE$, $MSG$, $APP$"
  Dim ls_req As String
    
  ls_req = Replace(InsertReq, "$UCODE$", CStr(0))
  ls_req = Replace(ls_req, "$APP$", SqlStr(App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision, 50))
  ls_req = Replace(ls_req, "$MSG$", SqlStr(as_LogMsg, 4000))
  ls_req = Replace(ls_req, "$LOGTYPE$", SqlStr(as_LogType), 1)
  
  Call aDb.ExecuteSQL(ls_req)
End Sub

Public Function SqlStr(ByVal av_Data As Variant, Optional ByVal al_MaxLength As Long = 0) As String

  If IsNull(av_Data) Then av_Data = ""
  If al_MaxLength = 0 Then
    SqlStr = "'" & Replace(CStr(av_Data), "'", "''") & "'"
  Else
    SqlStr = "'" & Replace(Left(CStr(av_Data), al_MaxLength), "'", "''") & "'"
  End If
End Function

Function CreateDir(ByVal dir_tested As String) As Boolean
   Dim fs As Object
   Dim MainFolder As Object
CreateDir = False

Set fs = CreateObject("Scripting.FileSystemObject")
If Not fs.FolderExists(dir_tested) Then
Set MainFolder = fs.CreateFolder(dir_tested)
End If
If fs.FolderExists(dir_tested) Then
CreateDir = True
End If
Set MainFolder = Nothing
Set fs = Nothing
End Function

Public Function GetSysDir() As String
    
    Dim ls_Buff As String, ll_Count As Long
    ls_Buff = SPACE(256)
    ll_Count = GetSystemDirectory(ls_Buff, 256)
    
    GetSysDir = Left(ls_Buff, ll_Count)

End Function

Public Function GetwindowsDir() As String
    Dim ls_Buff As String, ll_Count As Long
    ls_Buff = SPACE(256)
    ll_Count = GetWindowsDirectory(ls_Buff, 256)
    GetwindowsDir = Left(ls_Buff, ll_Count)
End Function


Private Function GetArrayValue(ByRef ao_variantArray As Variant, ByVal al_Index As Long) As Variant
    If IsArray(ao_variantArray) Then
        If UBound(ao_variantArray) <= al_Index Then
            GetArrayValue = ao_variantArray(al_Index)
        Else
            GetArrayValue = 0
        End If
    Else
        GetArrayValue = 0
    End If
End Function

